<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp\Promise;

function queue(TaskQueueInterface $assign = NULL)
{
    static $queue = NULL;
    if($assign) {
        $queue = $assign;
    } elseif(!$queue) {
        $queue = new TaskQueue();
    }
    return $queue;
}
function task(callable $task)
{
    $queue = queue();
    $promise = new Promise([$queue, "run"]);
    $queue->add(function () {
        static $task = NULL;
        static $promise = NULL;
        try {
            $promise->resolve($task());
        } catch (\Throwable $e) {
            $promise->reject($e);
        } catch (\Exception $e) {
            $promise->reject($e);
        }
    });
    return $promise;
}
function promise_for($value)
{
    if($value instanceof PromiseInterface) {
        return $value;
    }
    if(method_exists($value, "then")) {
        $wfn = method_exists($value, "wait") ? [$value, "wait"] : NULL;
        $cfn = method_exists($value, "cancel") ? [$value, "cancel"] : NULL;
        $promise = new Promise($wfn, $cfn);
        $value->then([$promise, "resolve"], [$promise, "reject"]);
        return $promise;
    }
    return new FulfilledPromise($value);
}
function rejection_for($reason)
{
    if($reason instanceof PromiseInterface) {
        return $reason;
    }
    return new RejectedPromise($reason);
}
function exception_for($reason)
{
    return $reason instanceof \Exception || $reason instanceof \Throwable ? $reason : new RejectionException($reason);
}
function iter_for($value)
{
    if($value instanceof \Iterator) {
        return $value;
    }
    if(is_array($value)) {
        return new \ArrayIterator($value);
    }
    return new \ArrayIterator([$value]);
}
function inspect(PromiseInterface $promise)
{
    try {
        return ["state" => PromiseInterface::FULFILLED, "value" => $promise->wait()];
    } catch (RejectionException $e) {
        return ["state" => PromiseInterface::REJECTED, "reason" => $e->getReason()];
    } catch (\Throwable $e) {
        return ["state" => PromiseInterface::REJECTED, "reason" => $e];
    } catch (\Exception $e) {
        return ["state" => PromiseInterface::REJECTED, "reason" => $e];
    }
}
function inspect_all($promises)
{
    $results = [];
    foreach ($promises as $key => $promise) {
        $results[$key] = inspect($promise);
    }
    return $results;
}
function unwrap($promises)
{
    $results = [];
    foreach ($promises as $key => $promise) {
        $results[$key] = $promise->wait();
    }
    return $results;
}
function all($promises)
{
    $results = [];
    return each($promises, function ($value, $idx) {
        static $results = NULL;
        $results[$idx] = $value;
    }, function ($reason, $idx, Promise $aggregate) {
        $aggregate->reject($reason);
    })->then(function () {
        static $results = NULL;
        ksort($results);
        return $results;
    });
}
function some($count, $promises)
{
    $results = [];
    $rejections = [];
    return each($promises, function ($value, $idx, PromiseInterface $p) {
        static $results = NULL;
        static $count = NULL;
        if($p->getState() !== PromiseInterface::PENDING) {
            return NULL;
        }
        $results[$idx] = $value;
        if($count <= count($results)) {
            $p->resolve(NULL);
        }
    }, function ($reason) {
        static $rejections = NULL;
        $rejections[] = $reason;
    })->then(function () {
        static $results = NULL;
        static $rejections = NULL;
        static $count = NULL;
        if(count($results) !== $count) {
            throw new AggregateException("Not enough promises to fulfill count", $rejections);
        }
        ksort($results);
        return array_values($results);
    });
}
function any($promises)
{
    return some(1, $promises)->then(function ($values) {
        return $values[0];
    });
}
function settle($promises)
{
    $results = [];
    return each($promises, function ($value, $idx) {
        static $results = NULL;
        $results[$idx] = ["state" => PromiseInterface::FULFILLED, "value" => $value];
    }, function ($reason, $idx) {
        static $results = NULL;
        $results[$idx] = ["state" => PromiseInterface::REJECTED, "reason" => $reason];
    })->then(function () {
        static $results = NULL;
        ksort($results);
        return $results;
    });
}
function each($iterable, callable $onFulfilled = NULL, callable $onRejected = NULL)
{
    return (new EachPromise($iterable, ["fulfilled" => $onFulfilled, "rejected" => $onRejected]))->promise();
}
function each_limit($iterable, $concurrency, callable $onFulfilled = NULL, callable $onRejected = NULL)
{
    return (new EachPromise($iterable, ["fulfilled" => $onFulfilled, "rejected" => $onRejected, "concurrency" => $concurrency]))->promise();
}
function each_limit_all($iterable, $concurrency, callable $onFulfilled = NULL)
{
    return each_limit($iterable, $concurrency, $onFulfilled, function ($reason, $idx, PromiseInterface $aggregate) {
        $aggregate->reject($reason);
    });
}
function is_fulfilled(PromiseInterface $promise)
{
    return $promise->getState() === PromiseInterface::FULFILLED;
}
function is_rejected(PromiseInterface $promise)
{
    return $promise->getState() === PromiseInterface::REJECTED;
}
function is_settled(PromiseInterface $promise)
{
    return $promise->getState() !== PromiseInterface::PENDING;
}
function coroutine(callable $generatorFn)
{
    return new Coroutine($generatorFn);
}

?>