<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp\Promise;

class RejectionException extends \RuntimeException
{
    private $reason;
    public function __construct($reason, $description = NULL)
    {
        $this->reason = $reason;
        $message = "The promise was rejected";
        if($description) {
            $message .= " with reason: " . $description;
        } elseif(is_string($reason) || is_object($reason) && method_exists($reason, "__toString")) {
            $message .= " with reason: " . $this->reason;
        } elseif($reason instanceof \JsonSerializable) {
            $message .= " with reason: " . json_encode($this->reason, JSON_PRETTY_PRINT);
        }
        parent::__construct($message);
    }
    public function getReason()
    {
        return $this->reason;
    }
}

?>