<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp\Promise;

class RejectedPromise implements PromiseInterface
{
    private $reason;
    public function __construct($reason)
    {
        if(method_exists($reason, "then")) {
            throw new \InvalidArgumentException("You cannot create a RejectedPromise with a promise.");
        }
        $this->reason = $reason;
    }
    public function then(callable $onFulfilled = NULL, callable $onRejected = NULL)
    {
        if(!$onRejected) {
            return $this;
        }
        $queue = queue();
        $reason = $this->reason;
        $p = new Promise([$queue, "run"]);
        $queue->add(function () {
            static $p = NULL;
            static $reason = NULL;
            static $onRejected = NULL;
            if($p->getState() === self::PENDING) {
                try {
                    $p->resolve($onRejected($reason));
                } catch (\Throwable $e) {
                    $p->reject($e);
                } catch (\Exception $e) {
                    $p->reject($e);
                }
            }
        });
        return $p;
    }
    public function otherwise(callable $onRejected)
    {
        return $this->then(NULL, $onRejected);
    }
    public function wait($unwrap = true, $defaultDelivery = NULL)
    {
        if($unwrap) {
            throw exception_for($this->reason);
        }
    }
    public function getState()
    {
        return self::REJECTED;
    }
    public function resolve($value)
    {
        throw new \LogicException("Cannot resolve a rejected promise");
    }
    public function reject($reason)
    {
        if($reason !== $this->reason) {
            throw new \LogicException("Cannot reject a rejected promise");
        }
    }
    public function cancel()
    {
    }
}

?>