<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace GuzzleHttp\Cookie;

class CookieJar implements CookieJarInterface
{
    private $cookies = [];
    private $strictMode;
    public function __construct($strictMode = false, $cookieArray = [])
    {
        $this->strictMode = $strictMode;
        foreach ($cookieArray as $cookie) {
            if(!$cookie instanceof SetCookie) {
                $cookie = new SetCookie($cookie);
            }
            $this->setCookie($cookie);
        }
    }
    public static function fromArray(array $cookies, $domain)
    {
        $cookieJar = new self();
        foreach ($cookies as $name => $value) {
            $cookieJar->setCookie(new SetCookie(["Domain" => $domain, "Name" => $name, "Value" => $value, "Discard" => true]));
        }
        return $cookieJar;
    }
    public static function getCookieValue($value)
    {
        return $value;
    }
    public static function shouldPersist(SetCookie $cookie, $allowSessionCookies = false)
    {
        if(($cookie->getExpires() || $allowSessionCookies) && !$cookie->getDiscard()) {
            return true;
        }
        return false;
    }
    public function getCookieByName($name)
    {
        if($name === NULL) {
            return NULL;
        }
        foreach ($this->cookies as $cookie) {
            if($cookie->getName() !== NULL && strcasecmp($cookie->getName(), $name) === 0) {
                return $cookie;
            }
        }
    }
    public function toArray()
    {
        return array_map(function (SetCookie $cookie) {
            return $cookie->toArray();
        }, $this->getIterator()->getArrayCopy());
    }
    public function clear($domain = NULL, $path = NULL, $name = NULL)
    {
        if(!$domain) {
            $this->cookies = [];
        } elseif(!$path) {
            $this->cookies = array_filter($this->cookies, function (SetCookie $cookie) {
                static $domain = NULL;
                return !$cookie->matchesDomain($domain);
            });
        } elseif(!$name) {
            $this->cookies = array_filter($this->cookies, function (SetCookie $cookie) {
                static $path = NULL;
                static $domain = NULL;
                return !($cookie->matchesPath($path) && $cookie->matchesDomain($domain));
            });
        } else {
            $this->cookies = array_filter($this->cookies, function (SetCookie $cookie) {
                static $path = NULL;
                static $domain = NULL;
                static $name = NULL;
                return !($cookie->getName() == $name && $cookie->matchesPath($path) && $cookie->matchesDomain($domain));
            });
        }
    }
    public function clearSessionCookies()
    {
        $this->cookies = array_filter($this->cookies, function (SetCookie $cookie) {
            return !$cookie->getDiscard() && $cookie->getExpires();
        });
    }
    public function setCookie(SetCookie $cookie)
    {
        $name = $cookie->getName();
        if(!$name && $name !== "0") {
            return false;
        }
        $result = $cookie->validate();
        if($result !== true) {
            if($this->strictMode) {
                throw new \RuntimeException("Invalid cookie: " . $result);
            }
            $this->removeCookieIfEmpty($cookie);
            return false;
        }
        foreach ($this->cookies as $i => $c) {
            if($c->getPath() != $cookie->getPath() || $c->getDomain() != $cookie->getDomain() || $c->getName() != $cookie->getName()) {
            } elseif(!$cookie->getDiscard() && $c->getDiscard()) {
                unset($this->cookies[$i]);
            } elseif($c->getExpires() < $cookie->getExpires()) {
                unset($this->cookies[$i]);
            } elseif($cookie->getValue() !== $c->getValue()) {
                unset($this->cookies[$i]);
            } else {
                return false;
            }
        }
        $this->cookies[] = $cookie;
        return true;
    }
    public function count()
    {
        return count($this->cookies);
    }
    public function getIterator()
    {
        return new \ArrayIterator(array_values($this->cookies));
    }
    public function extractCookies(\Psr\Http\Message\RequestInterface $request, \Psr\Http\Message\ResponseInterface $response)
    {
        if($cookieHeader = $response->getHeader("Set-Cookie")) {
            foreach ($cookieHeader as $cookie) {
                $sc = SetCookie::fromString($cookie);
                if(!$sc->getDomain()) {
                    $sc->setDomain($request->getUri()->getHost());
                }
                if(0 !== strpos($sc->getPath(), "/")) {
                    $sc->setPath($this->getCookiePathFromRequest($request));
                }
                $this->setCookie($sc);
            }
        }
    }
    private function getCookiePathFromRequest(\Psr\Http\Message\RequestInterface $request)
    {
        $uriPath = $request->getUri()->getPath();
        if("" === $uriPath) {
            return "/";
        }
        if(0 !== strpos($uriPath, "/")) {
            return "/";
        }
        if("/" === $uriPath) {
            return "/";
        }
        if(0 === ($lastSlashPos = strrpos($uriPath, "/"))) {
            return "/";
        }
        return substr($uriPath, 0, $lastSlashPos);
    }
    public function withCookieHeader(\Psr\Http\Message\RequestInterface $request)
    {
        $values = [];
        $uri = $request->getUri();
        $scheme = $uri->getScheme();
        $host = $uri->getHost();
        $path = $uri->getPath() ?: "/";
        foreach ($this->cookies as $cookie) {
            if($cookie->matchesPath($path) && $cookie->matchesDomain($host) && !$cookie->isExpired() && (!$cookie->getSecure() || $scheme === "https")) {
                $values[] = $cookie->getName() . "=" . $cookie->getValue();
            }
        }
        return $values ? $request->withHeader("Cookie", implode("; ", $values)) : $request;
    }
    private function removeCookieIfEmpty(SetCookie $cookie)
    {
        $cookieValue = $cookie->getValue();
        if($cookieValue === NULL || $cookieValue === "") {
            $this->clear($cookie->getDomain(), $cookie->getPath(), $cookie->getName());
        }
    }
}

?>