<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace CoinbaseCommerce\Tests;

class UtilTest extends \PHPUnit\Framework\TestCase
{
    public function testHashEqualSuccess()
    {
        $this->assertTrue(\CoinbaseCommerce\Util::hashEqual("8be7742c7d372f08a6a3224edadf18a22b65fa9e28f3f2de97376cdaa092590", "8be7742c7d372f08a6a3224edadf18a22b65fa9e28f3f2de97376cdaa092590"));
        $this->assertFalse(\CoinbaseCommerce\Util::hashEqual("8be7742c7d372f08a6a3224edadf18a22b65fa9e28f3f2de97376cdaa09259r", "8be7742c7d372f08a6a3224edadf18a22b65fa9e28f3f2de97376cdaa092590"));
        $this->assertFalse(\CoinbaseCommerce\Util::hashEqual("sdfdsfsdf", "sd"));
    }
    public function testEqual()
    {
        $this->assertTrue(\CoinbaseCommerce\Util::equal(["prop1" => ["value1"], "prop2" => ["propinheritlevel1" => ["propinheritlevel2" => "valueinheritlevel2"]]], ["prop1" => ["value1"], "prop2" => ["propinheritlevel1" => ["propinheritlevel2" => "valueinheritlevel2"]]]));
        $this->assertFalse(\CoinbaseCommerce\Util::equal(["prop1" => ["value1"], "prop2" => ["propinheritlevel1" => ["propinheritlevel2" => "valueinheritlevel2"]]], ["prop1" => ["value1"], "prop2" => ["propinheritlevel1" => ["propinheritlevel2" => "anothervalueinheritlevel2"]]]));
        $this->assertFalse(\CoinbaseCommerce\Util::equal(["prop1" => ["value1"], "prop2" => ["propinheritlevel1" => ["propinheritlevel2" => "valueinheritlevel2"]]], ["prop1" => ["value1"], "prop2" => ["propinheritlevel1" => ["anotherpropinheritlevel2" => "valueinheritlevel2"]]]));
        $this->assertFalse(\CoinbaseCommerce\Util::equal([], false));
        $this->assertTrue(\CoinbaseCommerce\Util::equal([], []));
        $this->assertTrue(\CoinbaseCommerce\Util::equal("some test string", "some test string"));
    }
    public function testGetResourcePath()
    {
        $this->assertEquals("part1/part2", \CoinbaseCommerce\Util::joinPath("part1/", "part2"));
        $this->assertEquals("part1/part2", \CoinbaseCommerce\Util::joinPath("/part1/", "/part2/"));
        $this->assertEquals("http://test.com/part1?key=value", \CoinbaseCommerce\Util::joinPath("http://test.com", "part1?key=value"));
    }
}

?>