<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace CoinbaseCommerce\Tests\Resources;

class CheckoutTest extends \CoinbaseCommerce\Tests\BaseTest
{
    public function setUp()
    {
        parent::setUp();
        \CoinbaseCommerce\Resources\Checkout::setClient($this->apiClient);
    }
    public function testRefreshMethod()
    {
        $this->appendRequest(200, $this->parseJsonFile("checkout.json"));
        $id = "488fcbd5-eb82-42dc-8a2b-10fdf70e0bfe";
        $checkoutObj = new \CoinbaseCommerce\Resources\Checkout();
        $checkoutObj->id = $id;
        $checkoutObj->refresh();
        $this->assertRequested("GET", "/checkouts/" . $id, "");
        $this->assertEquals("Test Description", $checkoutObj->description);
    }
    public function testRetrieveMethod()
    {
        $this->appendRequest(200, $this->parseJsonFile("checkout.json"));
        $id = "488fcbd5-eb82-42dc-8a2b-10fdf70e0bfe";
        $checkoutObj = \CoinbaseCommerce\Resources\Checkout::retrieve($id);
        $this->assertRequested("GET", "/checkouts/" . $id, "");
        $this->assertEquals("Test Description", $checkoutObj["description"]);
        $this->assertEquals("Test Description", $checkoutObj->description);
    }
    public function testListMethod()
    {
        $this->appendRequest(200, $this->parseJsonFile("checkoutList.json"));
        $checkoutList = \CoinbaseCommerce\Resources\Checkout::getList(["limit" => 2]);
        $this->assertRequested("GET", "/checkouts", "limit=2");
        $this->assertInstanceOf(\CoinbaseCommerce\ApiResourceList::getClassName(), $checkoutList);
        $this->assertEquals("Mastering the Transition to the Information Age", $checkoutList[0]["description"]);
        $this->assertEquals("Mastering the Transition to the Information Age", $checkoutList[0]->description);
    }
    public function testInsertMethod()
    {
        $this->appendRequest(200, $this->parseJsonFile("checkout.json"));
        $data = ["name" => "Test Name", "description" => "Test description"];
        $checkoutObj = new \CoinbaseCommerce\Resources\Checkout($data);
        $checkoutObj->insert();
        $this->assertRequested("POST", "/checkouts", "");
        $this->assertEquals("Test Name", $checkoutObj->name);
    }
    public function testInsertSaveMethod()
    {
        $this->appendRequest(200, $this->parseJsonFile("checkout.json"));
        $checkoutObj = new \CoinbaseCommerce\Resources\Checkout(["name" => "Test Name", "description" => "Test description"]);
        $checkoutObj->save();
        $this->assertRequested("POST", "/checkouts", "");
        $this->assertInstanceOf(\CoinbaseCommerce\Resources\Checkout::getClassName(), $checkoutObj);
        $this->assertEquals("Test Name", $checkoutObj->name);
    }
    public function testCreateMethod()
    {
        $this->appendRequest(200, $this->parseJsonFile("checkout.json"));
        $chargeObj = \CoinbaseCommerce\Resources\Checkout::create(["name" => "Test Name", "description" => "Test description"]);
        $this->assertRequested("POST", "/checkouts", "");
        $this->assertInstanceOf(\CoinbaseCommerce\Resources\Checkout::getClassName(), $chargeObj);
        $this->assertEquals("Test Name", $chargeObj->name);
    }
    public function testUpdateMethod()
    {
        $this->appendRequest(200, $this->parseJsonFile("checkout.json"));
        $id = "488fcbd5-eb82-42dc-8a2b-10fdf70e0bfe";
        $checkoutObj = new \CoinbaseCommerce\Resources\Checkout(["id" => $id, "name" => "Test Name", "description" => "Test description"]);
        $checkoutObj->update();
        $this->assertRequested("PUT", "/checkouts/" . $id, "");
        $this->assertEquals("Test Description", $checkoutObj["description"]);
        $this->assertEquals("Test Description", $checkoutObj->description);
    }
    public function testUpdateByIdMethod()
    {
        $this->appendRequest(200, $this->parseJsonFile("checkout.json"));
        $id = "488fcbd5-eb82-42dc-8a2b-10fdf70e0bfe";
        $data = ["name" => "Test Name", "description" => "Test description"];
        $checkoutObj = \CoinbaseCommerce\Resources\Checkout::updateById($id, $data);
        $this->assertRequested("PUT", "/checkouts/" . $id, "");
        $this->assertEquals("Test Description", $checkoutObj["description"]);
        $this->assertEquals("Test Description", $checkoutObj->description);
    }
    public function testUpdateSaveMethod()
    {
        $this->appendRequest(200, $this->parseJsonFile("checkout.json"));
        $id = "488fcbd5-eb82-42dc-8a2b-10fdf70e0bfe";
        $checkoutObj = new \CoinbaseCommerce\Resources\Checkout(["id" => $id, "name" => "Test Name", "description" => "Test Description"]);
        $checkoutObj->save();
        $this->assertRequested("PUT", "/checkouts/" . $id, "");
        $this->assertEquals("Test Description", $checkoutObj["description"]);
        $this->assertEquals("Test Description", $checkoutObj->description);
    }
}

?>