<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace CoinbaseCommerce\Tests;

class ApiCollectionListTest extends BaseTest
{
    public function testInitCollection()
    {
        \CoinbaseCommerce\Resources\Charge::setClient($this->apiClient);
        \CoinbaseCommerce\ApiResourceList::setClient($this->apiClient);
        $firstPageChargeList = $this->parseJsonFile("firstPageChargeList.json");
        $secondPageChargeList = $this->parseJsonFile("secondPageChargeList.json");
        $this->appendRequest(200, $firstPageChargeList);
        $this->appendRequest(200, $secondPageChargeList);
        $list = \CoinbaseCommerce\Resources\Charge::getList(["limit" => 2]);
        $this->assertInstanceOf(\CoinbaseCommerce\Resources\Charge::getClassName(), $list[0]);
        $this->assertCount(2, $list);
        $this->assertEquals(3, $list->countAll());
        $this->assertEquals($firstPageChargeList["pagination"], $list->getPagination());
        $this->assertTrue($list->hasNext());
        $this->assertTrue($list->hasPrev());
        $list->loadNext();
        $this->assertInstanceOf(\CoinbaseCommerce\Resources\Charge::getClassName(), $list[0]);
        $this->assertEquals($firstPageChargeList["data"][0]["name"], $list[0]["name"]);
        $this->assertEquals(3, $list->countAll());
        $this->assertCount(1, $list);
        $this->assertEquals($secondPageChargeList["pagination"], $list->getPagination());
        $this->assertRequested("GET", "/charges", "limit=2");
        $this->assertRequested("GET", "/charges", "limit=2&starting_after=" . $firstPageChargeList["pagination"]["cursor_range"][1]);
    }
}

?>