<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace CoinbaseCommerce\Tests;

class ApiClientTest extends \PHPUnit\Framework\TestCase
{
    public function setUp()
    {
        parent::setUp();
    }
    public function testFailOnGetInstanceWithoutInit()
    {
        \CoinbaseCommerce\ApiClient::getInstance();
    }
    public function testInitWithParams()
    {
        $apiKey = "test_api_key";
        $baseApiUrl = "http://test.com/";
        $apiVersion = "2018-03-20";
        $timeout = 5;
        $client = \CoinbaseCommerce\ApiClient::init($apiKey, $baseApiUrl, $apiVersion, $timeout);
        $this->assertEquals($apiKey, $client->getApiKey());
        $this->assertEquals($baseApiUrl, $client->getBaseUrl());
        $this->assertEquals($apiVersion, $client->getApiVersion());
        $this->assertEquals($timeout, $client->getTimeout());
    }
    public function testCorrectReinit()
    {
        $apiKey = "test_api_key";
        $baseApiUrl = "http://test.com/";
        $apiVersion = "2018-03-20";
        $timeout = 5;
        $clientFirst = \CoinbaseCommerce\ApiClient::init($apiKey, $baseApiUrl, $apiVersion, $timeout);
        $apiKey = "another_test_api_key";
        $clientSecond = \CoinbaseCommerce\ApiClient::init($apiKey, $baseApiUrl, $apiVersion, $timeout);
        $this->assertSame($clientFirst, $clientSecond);
        $this->assertInstanceOf(\CoinbaseCommerce\ApiClient::getClassName(), $clientSecond);
    }
}

?>