<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace CoinbaseCommerce;

class Webhook
{
    public static function buildEvent($payload, $sigHeader, $secret)
    {
        $data = NULL;
        $data = json_decode($payload, true);
        if(json_last_error()) {
            throw new Exceptions\InvalidResponseException("Invalid payload provided. No JSON object could be decoded.", $payload);
        }
        if(!isset($data["event"])) {
            throw new Exceptions\InvalidResponseException("Invalid payload provided.", $payload);
        }
        self::verifySignature($payload, $sigHeader, $secret);
        return new Resources\Event($data["event"]);
    }
    public static function verifySignature($payload, $sigHeader, $secret)
    {
        $computedSignature = hash_hmac("sha256", $payload, $secret);
        if(!Util::hashEqual($sigHeader, $computedSignature)) {
            throw new Exceptions\SignatureVerificationException($computedSignature, $payload);
        }
    }
}

?>