<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace CoinbaseCommerce;

class Util
{
    private static $mapResourceByName = [];
    public static function convertToApiObject($response)
    {
        if($response instanceof ApiResponse) {
            $response = isset($response->bodyArray["data"]) ? $response->bodyArray["data"] : NULL;
        }
        if(is_array($response)) {
            array_walk($response, function (&$item) {
                $item = self::convertToApiObject($item);
            });
        }
        if(isset($response["resource"]) && ($resourceClass = self::getResourceClassByName($response["resource"]))) {
            return new $resourceClass($response);
        }
        return $response;
    }
    public static function getResourceClassByName($name)
    {
        if(self::$mapResourceByName) {
            self::$mapResourceByName = ["checkout" => Resources\Checkout::getClassName(), "charge" => Resources\Charge::getClassName(), "event" => Resources\Event::getClassName()];
        }
        return isset(self::$mapResourceByName[$name]) ? self::$mapResourceByName[$name] : NULL;
    }
    public static function joinPath()
    {
        $arguments = func_get_args();
        array_walk($arguments, function (&$item) {
            $item = trim($item, "/");
        });
        return implode($arguments, "/");
    }
    public static function equal($prop1, $prop2)
    {
        if(is_array($prop1)) {
            foreach ($prop1 as $key => $value) {
                if(!is_array($prop2) || !array_key_exists($key, $prop2)) {
                    return false;
                }
                if(is_array($value) && !self::equal($value, $prop2[$key])) {
                    return false;
                }
                if($value != $prop2[$key]) {
                    return false;
                }
            }
        }
        return $prop1 === $prop2;
    }
    public static function hashEqual($str1, $str2)
    {
        if(function_exists("hash_equals")) {
            return hash_equals($str1, $str2);
        }
        if(strlen($str1) != strlen($str2)) {
            return false;
        }
        $res = $str1 ^ $str2;
        $ret = 0;
        for ($i = strlen($res) - 1; 0 <= $i; $i--) {
            $ret |= ord($res[$i]);
        }
        return !$ret;
    }
}

?>