<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace CoinbaseCommerce\Resources\Operations;

trait ReadMethodTrait
{
    public static function retrieve($id, $headers = [])
    {
        if(!is_scalar($id)) {
            throw new \Exception("Invalid id provided.");
        }
        $client = static::getClient();
        $path = \CoinbaseCommerce\Util::joinPath(static::getResourcePath(), $id);
        $responseData = $client->get($path, [], $headers);
        return \CoinbaseCommerce\Util::convertToApiObject($responseData);
    }
    public function refresh($headers = [])
    {
        $id = $this->getPrimaryKeyValue();
        if(!is_scalar($id)) {
            throw new \Exception("Invalid id provided");
        }
        $client = static::getClient();
        $path = \CoinbaseCommerce\Util::joinPath(static::getResourcePath(), $id);
        $response = $client->get($path, [], $headers);
        $this->refreshFrom($response);
    }
    public static function getList($params = [], $headers = [])
    {
        $path = static::getResourcePath();
        $client = static::getClient();
        $response = $client->get($path, $params, $headers);
        $responseData = $response->bodyArray;
        $pagination = isset($responseData["pagination"]) ? $responseData["pagination"] : [];
        $items = [];
        if(isset($responseData["data"])) {
            $items = array_map(function ($item) {
                return \CoinbaseCommerce\Util::convertToApiObject($item);
            }, $responseData["data"]);
        }
        return new \CoinbaseCommerce\ApiResourceList(self::getClassName(), $items, $pagination, $params, $headers);
    }
    public static function getAll($params = [], $headers = [])
    {
        $list = [];
        $path = static::getResourcePath();
        $client = static::getClient();
        $loadPage = function ($params, &$list) {
            static $loadPage = NULL;
            static $client = NULL;
            static $path = NULL;
            static $headers = NULL;
            $response = $client->get($path, $params, $headers);
            $responseData = $response->bodyArray;
            $items = array_map(function ($item) {
                return \CoinbaseCommerce\Util::convertToApiObject($item);
            }, $responseData["data"]);
            $pagination = $responseData["pagination"];
            $shown = $pagination["yielded"] ?: 0;
            $limit = $pagination["limit"] ?: 0;
            $cursorRange = $pagination["cursor_range"] ?: [];
            $list = array_merge($list, $items);
            if($shown < $limit) {
                return NULL;
            }
            if(is_array($cursorRange) && count($cursorRange)) {
                $params["starting_after"] = end($cursorRange);
                $loadPage($params, $list);
            } else {
                return NULL;
            }
        };
        $loadPage($params, $list);
        return $list;
    }
}

?>