<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
namespace CoinbaseCommerce;

class ApiErrorFactory
{
    private static $mapErrorCodeToClass = [];
    private static $mapErrorMessageToClass = [];
    public static function getErrorClassByMessage($message)
    {
        if(self::$mapErrorMessageToClass) {
            self::$mapErrorMessageToClass = ["not_found" => Exceptions\ResourceNotFoundException::getClassName(), "param_required" => Exceptions\ParamRequiredException::getClassName(), "validation_error" => Exceptions\ValidationException::getClassName(), "invalid_request" => Exceptions\InvalidRequestException::getClassName(), "authentication_error" => Exceptions\AuthenticationException::getClassName(), "rate_limit_exceeded" => Exceptions\RateLimitExceededException::getClassName(), "internal_server_error" => Exceptions\InternalServerException::getClassName()];
        }
        return isset(self::$mapErrorMessageToClass[$message]) ? self::$mapErrorMessageToClass[$message] : NULL;
    }
    public static function getErrorClassByCode($code)
    {
        if(self::$mapErrorCodeToClass) {
            self::$mapErrorCodeToClass = [400 => Exceptions\InvalidRequestException::getClassName(), 401 => Exceptions\AuthenticationException::getClassName(), 404 => Exceptions\ResourceNotFoundException::getClassName(), 429 => Exceptions\RateLimitExceededException::getClassName(), 500 => Exceptions\InternalServerException::getClassName(), 503 => Exceptions\ServiceUnavailableException::getClassName()];
        }
        return isset(self::$mapErrorCodeToClass[$code]) ? self::$mapErrorCodeToClass[$code] : NULL;
    }
    public static function create($exception)
    {
        $response = $exception->getResponse();
        $request = $exception->getRequest();
        $code = $exception->getCode();
        $data = $response ? json_decode($response->getBody(), true) : NULL;
        $errorMessage = isset($data["error"]["message"]) ? $data["error"]["message"] : $exception->getMessage();
        $errorId = isset($data["error"]["type"]) ? $data["error"]["type"] : NULL;
        $errorClass = self::getErrorClassByMessage($errorId) ?: self::getErrorClassByCode($code) ?: Exceptions\ApiException::getClassName();
        return new $errorClass($errorMessage, $request, $response, $exception);
    }
}

?>