<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
require_once __DIR__ . "/vendor/autoload.php";
CoinbaseCommerce\ApiClient::init("API_KEY");
$checkoutObj = new CoinbaseCommerce\Resources\Checkout(["description" => "Mastering the Transition to the Information Age", "local_price" => ["amount" => "1.00", "currency" => "USD"], "name" => "test item 15 edited", "pricing_type" => "fixed_price", "requested_info" => ["email"]]);
try {
    $checkoutObj->save();
    echo sprintf("Successfully created new checkout with id: %s \n", $checkoutObj->id);
} catch (Exception $exception) {
    echo sprintf("Enable to create checkout. Error: %s \n", $exception->getMessage());
}
if($checkoutObj->id) {
    $checkoutObj->name = "New name";
    try {
        $checkoutObj->save();
        echo sprintf("Successfully updated name of checkout via save method\n");
    } catch (Exception $exception) {
        echo sprintf("Enable to update name of checkout. Error: %s \n", $exception->getMessage());
    }
    try {
        CoinbaseCommerce\Resources\Checkout::updateById($checkoutObj->id, ["name" => "Another Name"]);
        echo sprintf("Successfully updated name of checkout by id\n");
    } catch (Exception $exception) {
        echo sprintf("Enable to update name of checkout by id. Error: %s \n", $exception->getMessage());
    }
    $checkoutObj->description = "New description";
    try {
        $checkoutObj->refresh();
        echo sprintf("Successfully refreshed checkout\n");
    } catch (Exception $exception) {
        echo sprintf("Enable to refresh checkout. Error: %s \n", $exception->getMessage());
    }
    try {
        $retrievedCheckout = CoinbaseCommerce\Resources\Checkout::retrieve($checkoutObj->id);
        echo sprintf("Successfully retrieved checkout\n");
        echo $retrievedCheckout;
    } catch (Exception $exception) {
        echo sprintf("Enable to retrieve checkout. Error: %s \n", $exception->getMessage());
    }
}
try {
    $list = CoinbaseCommerce\Resources\Checkout::getList(["limit" => 5]);
    echo sprintf("Successfully got list of checkouts\n");
    if(count($list)) {
        echo sprintf("Checkouts in list:\n");
        foreach ($list as $checkout) {
            echo $checkout;
        }
    }
    echo sprintf("List's pagination:\n");
    print_r($list->getPagination());
    echo sprintf("Number of all checkouts - %s \n", $list->countAll());
} catch (Exception $exception) {
    echo sprintf("Enable to get list of checkouts. Error: %s \n", $exception->getMessage());
}
if(isset($list) && $list->hasNext()) {
    try {
        $list->loadNext();
        echo sprintf("Next page of checkouts: \n");
        foreach ($list as $checkout) {
            echo $checkout;
        }
    } catch (Exception $exception) {
        echo sprintf("Enable to get new page of checkouts. Error: %s \n", $exception->getMessage());
    }
}
try {
    $allCharge = CoinbaseCommerce\Resources\Checkout::getAll();
    echo sprintf("Successfully got all checkouts:\n");
    foreach ($allCharge as $charge) {
        echo $charge;
    }
} catch (Exception $exception) {
    echo sprintf("Enable to get all checkouts. Error: %s \n", $exception->getMessage());
}

?>