<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.1.6
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
require_once __DIR__ . "/library/coinbase_api/autoload.php";
function create($data)
{
    CoinbaseCommerce\ApiClient::init($data->key);
    $chargeObj = new CoinbaseCommerce\Resources\Charge(["description" => $data->description, "metadata" => ["customer_id" => $data->uid, "customer_name" => $data->email], "local_price" => ["amount" => $data->amount, "currency" => $data->currency], "name" => $data->name, "payments" => [], "redirect_url" => $data->redirect_url, "cancel_url" => $data->cancel, "pricing_type" => "fixed_price"]);
    try {
        $chargeObj->save();
        $redirect_url = $chargeObj->hosted_url;
        $result = (object) ["status" => "success", "redirect_url" => $redirect_url, "txn_id" => $chargeObj->id];
    } catch (Exception $exception) {
        $result = (object) ["status" => "error", "message" => $exception->getMessage()];
    }
    return $result;
}
function get_transaction_detail_info($transaction_id)
{
    try {
        $response = CoinbaseCommerce\Resources\Charge::retrieve($transaction_id);
        $result = ["status" => "success", "data" => $response];
    } catch (Exception $exception) {
        $result = ["status" => "error", "data" => $exception->getMessage()];
    }
    return (object) $result;
}

?>